*! version 5.0
* 13 August 2018
* NIDS
* Master Wealth do file for Nids Wave 2

* THIS IS 5th WEALTH DO FILE - PRE IMPUTATION AGGREGATION DO FILE: 5 OF 6
* THIS DO FILE AGGREGATES THE IMPUTATION WEALTH VARIABLES

*=====================================================================================================================================
* GLOBALS FOR DATA FILES, DO FILES AND VERSION SUFFIXES

* DEFINED IN "Master Wealth do file (1 of 6)"

version 12.0

*=====================================================================================================================================

* OPENING DATASET PREPARED IN PRIOR DO FILE "Wealth - Performing Imputations on Wealth varaibles (4 of 6).do"

set more off

use "$DataOUT\impdata.dta", clear

*-------------------------------------------------------------------------------------------------------------------------------------

************************
*Unit non-response rate*
************************

sort w2_hhid
egen hhunitR=sum(response), by(w2_hhid)
gen temp=1 if pid!=.
egen hhsize_adult=count(temp), by(w2_hhid)
drop temp
gen hhunitNRR=1-(hhunitR/hhsize_adult)
recode hhunitNRR (0=0 "0%") (0.0001/0.24999=1 "0%-25%") (0.25/0.4999=2 "25% - 49%") ///
(0.5/0.74999=3 "50% - 74%") (0.75/0.999=4 "75% - 100%") (1=5 "100%"), gen(hhunitNRR_6)

*******************************************************


*Household-level
egen pi_re_ass=rowtotal(houseval otherhouseval), mi
egen pi_re_deb=rowtotal(housedebt otherhousedebt), mi

egen pi_lvstk_ass=rowtotal(cattle sheep goats pigs horses donkeys chickens), m

*Individual-level
*PRE-IMPUTATION AGGREGATION

*Business Assets

sort w2_hhid
by w2_hhid: egen pi_b_ass=sum(busass)

*Vehicle Assets

sort w2_hhid
by w2_hhid: egen temp1=sum(priveh)
by w2_hhid:egen temp2=sum(bakkie)
by w2_hhid: egen temp3=sum(scooter)
egen pi_v_ass=rowtotal(temp1 temp2 temp3), mi
drop temp*

*Financial Assets

sort w2_hhid
by w2_hhid: egen temp1=sum(cash)
by w2_hhid: egen temp2=sum(bank)
by w2_hhid: egen temp3=sum(life)
by w2_hhid: egen temp4=sum(stocks)
egen pi_f_ass=rowtotal(temp*), m
drop temp*

*Retirement Plan

sort w2_hhid
by w2_hhid: egen pi_s_ass=sum(pension)

*Business Debt

sort w2_hhid 
by w2_hhid: egen pi_b_deb=sum(busdeb)

*Vehicle Debt

sort w2_hhid
by w2_hhid: egen pi_v_deb=sum(vehdebt)

*Financial Debt

sort w2_hhid
foreach var of varlist bankdebt micro masho studentloan otherstudentloan creditcard ///
store hirep famloan friendloan emploan unpaidtax {
by w2_hhid: egen temp`var'=sum(`var')
}
egen pi_f_deb=rowtotal(temp*), m
drop temp*


*POST-IMPUTATION AGGREGATION

*HOUSEHOLD-LEVEL VARIABLES
egen re_ass=rowtotal(houseval_imp otherhouseval_imp), mi
egen re_deb=rowtotal(housedebt_imp otherhousedebt_imp), mi

egen lvstk_ass=rowtotal(cattle_imp sheep_imp goats_imp pigs_imp horses_imp donkeys_imp chickens_imp), mi

*INDIVIDUAL-LEVEL VARIABLES

*Business Assets
sort w2_hhid
by w2_hhid: egen b_ass=sum(busass_imp)

*Vehicle Assets
sort w2_hhid
by w2_hhid: egen temp1=sum(priveh_imp)
by w2_hhid:egen temp2=sum(bakkie_imp)
by w2_hhid: egen temp3=sum(scooter_imp)
egen v_ass=rowtotal(temp1 temp2 temp3), mi
drop temp*

*Financial Assets
sort w2_hhid
by w2_hhid: egen temp1=sum(cash_imp)
by w2_hhid: egen temp2=sum(bank_imp)
by w2_hhid: egen temp3=sum(life_imp)
by w2_hhid: egen temp4=sum(stocks_imp)
egen f_ass=rowtotal(temp*), m
drop temp*

*Retirement Plan
sort w2_hhid
by w2_hhid: egen s_ass=sum(pension_imp)

*Business Debt
sort w2_hhid 
by w2_hhid: egen b_deb=sum(busdeb_imp)

*Vehicle Debt
sort w2_hhid
by w2_hhid: egen v_deb=sum(vehdebt_imp)

*Financial Debt
sort w2_hhid
foreach var of varlist bankdebt_imp micro_imp masho_imp studentloan_imp ///
otherstudentloan_imp creditcard_imp store_imp hirep_imp famloan_imp ///
friendloan_imp emploan_imp unpaidtax_imp {
by w2_hhid: egen temp`var'=sum(`var')
}
egen f_deb=rowtotal(temp*), m
drop temp*

****************************************************************

foreach var of varlist pi_b_ass-f_deb {
replace `var'=. if `var'==0
replace `var'=. if hhunitNRR>0 & hhq_networth!=.
}

/*So now we have set the components of net worth equal to missing for those HHs with
partial unit non-response AND valid one-shot net worth. Those HHs with PUNR and missing
one-shot net-worth will have the components summed over the avaiable adults, as outlined
in the user document.*/

****************************************************************


*AGGREGATING UP TO THE HOUSEHOLD LEVEL
egen pi_tot_ass=rowtotal(pi_re_ass pi_b_ass pi_v_ass pi_f_ass pi_s_ass pi_lvstk_ass), m
egen pi_tot_deb=rowtotal(pi_re_deb pi_b_deb pi_v_deb pi_f_deb), m
egen tot_ass=rowtotal(re_ass b_ass v_ass f_ass s_ass lvstk_ass), m
egen tot_deb=rowtotal(re_deb b_deb v_deb f_deb), m

gen temp1=-(pi_tot_deb)
gen temp2=-(tot_deb)

egen pi_net_worth=rowtotal(pi_tot_ass temp1), m
egen net_worth=rowtotal(tot_ass temp2), m
drop temp*

********************************************************************

replace net_worth=hhq_networth if net_worth==. & hhq_networth!=.

sort w2_hhid
drop if w2_hhid==w2_hhid[_n-1]
keep w2_hhid hhq_networth pi_re_ass-net_worth

********************************************************************

save "$DataOUT\hhwealth.dta", replace

* end of do file
*===================================================================================================================================

